<?php

namespace CoinAccepted\Payment;

use Exception;

class Util
{
	public const ENVIRONMENT_PRODUCTION = 'production';

	public const METHOD_GET = 'GET';
	public const METHOD_POST = 'POST';

	public const HTTP_CODE_200 = 200;
	public const HTTP_CODE_404 = 404;

	public const TRANSACTION_STATUS_COMPLETED = 'COMPLETED';
	public const TRANSACTION_STATUS_ACTION_REQUIRED = 'ACTION_REQUIRED';

    public const AVAILABLE_TRANSACTION_STATUSES = [
        self::TRANSACTION_STATUS_COMPLETED,
        self::TRANSACTION_STATUS_ACTION_REQUIRED,
    ];

	private static array $supportedCurrencies = [
		'pln' => 'PLN',
		'eur' => 'EUR',
		'usd' => 'USD',
		'gbp' => 'GBP',
	];

	/**
	 * @throws Exception
	 */
	public static function generateUuidV4(): string
	{

		return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
			// 32 bits for "time_low"
			mt_rand(0, 0xffff), mt_rand(0, 0xffff),

			// 16 bits for "time_mid"
			mt_rand(0, 0xffff),

			// 16 bits for "time_hi_and_version",
			// four most significant bits holds version number 4
			mt_rand(0, 0x0fff) | 0x4000,

			// 16 bits, 8 bits for "clk_seq_hi_res",
			// 8 bits for "clk_seq_low",
			// two most significant bits holds zero and one for variant DCE1.1
			mt_rand(0, 0x3fff) | 0x8000,

			// 48 bits for "node"
			mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
		);
	}

	public static function canUseForCurrency(string $currencyCode): bool
	{
		return isset(self::$supportedCurrencies[strtolower($currencyCode)]);
	}

	public static function getServiceUrl(): string
	{
		$url = Configuration::getServiceUrl(Util::ENVIRONMENT_PRODUCTION);
		if (empty($url)) {
			return '';
		}

		return $url . Configuration::ROUTE_PAYMENTS;
	}

	public static function isJson(string $variable): bool
	{
		json_decode($variable);

		return (json_last_error() === JSON_ERROR_NONE);
	}

	public static function getSupportedCurrencies(): array
	{
		return self::$supportedCurrencies;
	}
}
