<?php

namespace CoinAccepted\Payment;

use Exception;

class Payment
{
	public function __construct(string $privateKey, string $publicKey)
	{
		Configuration::setPrivateKey($privateKey);
		Configuration::setPublicKey($publicKey);
	}

	/**
	 * @throws Exception
	 */
	public function buildOrder(string $currency, string $orderId, float $price, string $notificationEmail, string $notificationsUrl, string $successUrl, string $failureUrl): PaymentResult
	{
		return CoinAccepted::prepareOrderData(Configuration::getPrivateKey(), Configuration::getPublicKey(), $currency, $orderId, $price, $notificationEmail, $notificationsUrl, $successUrl, $failureUrl);
	}
}
