<?php

namespace CoinAccepted\Payment;

class Configuration
{

	const ROUTE_PAYMENTS = "/payments";

	private static array $serviceUrls = [
		Util::ENVIRONMENT_PRODUCTION => "https://api.coinaccepted.com/rest/pay",
	];

	private static string $privateKey;

	private static string $publicKey;

	public static function getPrivateKey(): string
	{
		return self::$privateKey;
	}

	public static function setPrivateKey(string $privateKey): void
	{
		self::$privateKey = trim($privateKey);
	}

	public static function getPublicKey(): string
	{
		return self::$publicKey;
	}

	public static function setPublicKey(string $publicKey): void
	{
		self::$publicKey = trim($publicKey);
	}

	public static function getServiceUrl(string $environment): string
	{
		return self::$serviceUrls[$environment];
	}
}
