<?php
/*
Plugin Name: WooCommerce CoinAccepted
Plugin URI: https://coinaccepted.com
Description: Add payment via CoinAccepted to WooCommerce
Version: 1.1.0
Author: CoinAccepted <pay@coinaccepted.com>
Author URI: https://coinaccepted.com
Text Domain: coinaccepted
*/

add_action('plugins_loaded', 'init_woocommerce_gateway_coinaccepted', 0);

/**
 * Init function that runs after plugin install.
 */
function init_woocommerce_gateway_coinaccepted()
{
	require_once __DIR__ . "/includes/libs/payment-core/vendor/autoload.php";

	if(!class_exists('WC_Payment_Gateway')) {
		return;
	}

	define('WOOCOMMERCE_COINACCEPTED_PLUGIN_DIR', plugin_dir_path(__FILE__));
	define('WOOCOMMERCE_COINACCEPTED_PLUGIN_URL', plugin_dir_url(__FILE__));
	define('WOOCOMMERCE_COINACCEPTED_VERSION', '1.1.0' );

	load_plugin_textdomain('coinaccepted', false, dirname(plugin_basename(__FILE__)) . '/langs/');

	require_once('includes/WCGatewayCoinAccepted.php');

	add_filter('woocommerce_payment_gateways', 'add_coinaccepted_gateway');
}

function add_coinaccepted_gateway(array $methods): array
{
	$methods[] = 'WC_Gateway_CoinAccepted';

	return $methods;
}

function add_coinaccepted_gateway_blocks_support(): void
{
    if ( class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
        require_once WOOCOMMERCE_COINACCEPTED_PLUGIN_DIR . '/includes/WCGatewayCoinAcceptedBlocksSupport.php';
        add_action(
            'woocommerce_blocks_payment_method_type_registration',
            function ( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
                $payment_method_registry->register( new WC_Gateway_CoinAccepted_Blocks_Support() );
            }
        );
    }
}

add_action( 'woocommerce_blocks_loaded', 'add_coinaccepted_gateway_blocks_support' );


