<?php

namespace CoinAccepted\Payment;

class Helper
{
	const VERSION = '1.2.0';

	private const AUTHOR = 'Coin Accepted';

	private const WEBSITE = 'https://coinaccepted.com/';

	public const ERROR_CONNECT = 'COULD_NOT_CONNECT_TO_API';

	public const ERROR_MESSAGE_FOR_CUSTOMER = 'MESSAGE_FOR_CUSTOMER';

	private static array $errorMessages = [
		'pl' => [
			'CURRENCY_DOES_NOT_EXIST'     => 'Nieprawidłowa waluta zamówienia',
			'NOT_ALLOWED_CURRENCY'        => 'Nieaktywna waluta zamówienia',
			'STORE_IS_INACTIVE'           => 'Sklep nieaktywny, brak możliwości wykonania operacji',
			'POS_IS_INACTIVE'             => 'POS nieaktywny, brak możliwości wykonania operacji',
			'SOURCE_CURRENCY_MUST_BE_SET' => 'Wartość parametru sourceCurrency musi być podana',
			'DESTINATION_CURRENCY_MUST_BE_SET'
			                              => 'Brak parametru destinationCurrency',
			'PAGE_SIZE_TOO_BIG'           => 'Zbyt duży rozmiar strony w żądaniu GET /payments/search',
			'PAGE_SIZE_TOO_SMALL'         => 'Zbyt mały rozmiar strony w żądaniu GET /payments/search',
			'INVALID_PAGE_NUMBER'         => 'Niepoprawny numer strony w żądaniu GET /payments/search',
			'WITHDRAWAL_NOT_ALLOWED'      => 'Wypłaty za pomocą API są nieaktywne',
			'OPERATION_ALREADY_PERFORMED' => 'Wartość nagłówka Operation-Id została już użyta',
			'WITHDRAWAL_AMOUNT_SMALLER_THAN_FEE'
			                              => 'Kwota wypłaty jest mniejsza niż kwota prowizji',
			'FORBIDDEN'                   => 'Błąd autoryzacji - sprawdź wprowadzone klucze',
			'ACCESS_DENIED'               => 'Błąd autoryzacji - sprawdź wprowadzone klucze',
			'PAY_PROFILE_DOES_NOT_EXIST'  => 'Błędna konfiguracja konta sprzedawcy',
			'PAYMENT_DOES_NOT_EXIST'      => 'Niepoprawny identyfikator płatności podczas pobierania informacji o płatności',
			'POS_DOES_NOT_EXIST'          => 'Identyfikator POS nie istnieje, lub jest niezgodny z identyfikatorem sklepu',
			'STORE_DOES_NOT_EXIST'        => 'Niepoprawny identyfikator sklepu',
			'API_KEY_NOT_FOUND_ERROR'     => 'Klucz API jest niepoprawny lub niezdefiniowany',
			'MUST_NOT_BE_NULL'            => 'Parametr nie może być pusty',
			'MUST_NOT_BE_BLANK'           => 'Parametr nie może być pusty',
			'MUST_BE_GREATER_THAN_ZERO'   => 'Wartość parametru musi być większa niż 0',
			'MUST_BE_IN_RANGE'            => 'Wartość parametru jest zbyt długa',
			'INVALID_URL'                 => 'Wartość musi zawierać adres w formacie URL',
			'INVALID_EMAIL_ADDRESS'       => 'Niepoprawny adres e-mail',
			'ONLY_PRICE_OR_AMOUNT_CAN_BE_SET'
			                              => 'Należy podać tylko parametr "price" lub "amount"',
			'VALUE_SCALE_INVALID'         => 'Nieprawidłowa dokładność zaokrąglenia wartości liczbowych',
			'DECIMAL_VALUE_TOO_SMALL'     => 'Zbyt niska kwota płatności/wypłaty',
			'DECIMAL_VALUE_TOO_BIG'       => 'Zbyt wysoka kwota płatności/wypłaty',
			'MUST_BE_COVERED_BY_MERCHANT' => 'Nieprawidłowa wartość parametru "coveredBy"',
			'INVALID_WALLET_ADDRESS'      => 'Błędny adres wypłaty',
			'WITHDRAWAL_OPERATION_ERROR'  => 'Błąd wypłaty',

			'MESSAGE_FOR_CUSTOMER'     => 'Wystąpił błąd po stronie operatora. Aby uzyskać więcej informacji skontaktuj się z właścicielem sklepu.',
			'COULD_NOT_CONNECT_TO_API' => 'Nie udało się połączyć z serwerem kryptowalut',
		],
		'en' => [
			'CURRENCY_DOES_NOT_EXIST'     => 'Invalid order currency',
			'NOT_ALLOWED_CURRENCY'        => 'Inactive order currency',
			'STORE_IS_INACTIVE'           => 'The store is inactive, unable to perform the operation',
			'POS_IS_INACTIVE'             => 'POS is inactive, unable to perform the operation',
			'SOURCE_CURRENCY_MUST_BE_SET' => 'The value of the sourceCurrency parameter must be provided',
			'DESTINATION_CURRENCY_MUST_BE_SET'
			                              => 'Parameter destinationCurrency must be provided',
			'PAGE_SIZE_TOO_BIG'           => 'Too big page size in GET /payments/search request',
			'PAGE_SIZE_TOO_SMALL'         => 'Too small page size in GET /payments/search request',
			'INVALID_PAGE_NUMBER'         => 'Invalid page number in GET /payments/search request',
			'WITHDRAWAL_NOT_ALLOWED'      => 'API withdrawals are inactive',
			'OPERATION_ALREADY_PERFORMED' => 'The value of the Operation-Id header has already been used',
			'WITHDRAWAL_AMOUNT_SMALLER_THAN_FEE'
			                              => 'The amount of the withdrawal is less than the amount of the fee',
			'FORBIDDEN'                   => 'Authorization error - check entered keys',
			'ACCESS_DENIED'               => 'Authorization error - check entered keys',
			'PAY_PROFILE_DOES_NOT_EXIST'  => 'Incorrect configuration of the vendor account',
			'PAYMENT_DOES_NOT_EXIST'      => 'Incorrect payment identifier while fetching payment information',
			'POS_DOES_NOT_EXIST'          => 'POS identifier does not exist, or is mismatched with the store identifier',
			'STORE_DOES_NOT_EXIST'        => 'Incorrect store ID',
			'API_KEY_NOT_FOUND_ERROR'     => 'API key is invalid or undefined',
			'MUST_NOT_BE_NULL'            => 'Parameter must not be NULL',
			'MUST_NOT_BE_BLANK'           => 'Parameter must not be blank',
			'MUST_BE_GREATER_THAN_ZERO'   => 'The parameter value must be greater than 0',
			'MUST_BE_IN_RANGE'            => 'The parameter value is too long',
			'INVALID_URL'                 => 'The value must contain the address in URL format',
			'INVALID_EMAIL_ADDRESS'       => 'Invalid e-mail address',
			'ONLY_PRICE_OR_AMOUNT_CAN_BE_SET'
			                              => 'Only the parameter "price" or "amount" should be set',
			'VALUE_SCALE_INVALID'         => 'Incorrect rounding accuracy of numerical values',
			'DECIMAL_VALUE_TOO_SMALL'     => 'Too small amount of payment/withdrawal',
			'DECIMAL_VALUE_TOO_BIG'       => 'Too high amount of payment/withdrawal',
			'MUST_BE_COVERED_BY_MERCHANT' => 'Incorrect value of the "coveredBy" parameter',
			'INVALID_WALLET_ADDRESS'      => 'Invalid wallet address',
			'WITHDRAWAL_OPERATION_ERROR'  => 'Withdrawal operation error',

			'MESSAGE_FOR_CUSTOMER'        => 'An error occurred on the operator side. For more information contact the owner of the store.',
			'COULD_NOT_CONNECT_TO_API'    => 'Failed to connect to the cryptocurriencies server',
		],
	];

	public static function getErrorMessage(string $code, string $lang): string
	{
		if(isset(self::$errorMessages[$lang][$code])) {
			return self::$errorMessages[$lang][$code];
		}

		return '';
	}
}
