<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_Gateway_CoinAccepted_Blocks_Support extends AbstractPaymentMethodType
{
    protected $name = 'ca_cryptocurrencies';

    public function initialize() {
        $this->settings = get_option( 'woocommerce_coinaccepted_settings', array() );
    }

    /**
     * Returns if this payment method should be active. If false, the scripts will not be enqueued.
     *
     * @return boolean
     */
    public function is_active() {
        $payment_gateways_class = WC()->payment_gateways();
        $payment_gateways       = $payment_gateways_class->payment_gateways();

        return $payment_gateways['ca_cryptocurrencies']->is_available();
    }

    public function get_payment_method_script_handles(): array {
        $version = WOOCOMMERCE_COINACCEPTED_VERSION;
        wp_register_script(
            'wc-coinaccepted-blocks-integration',
            WOOCOMMERCE_COINACCEPTED_PLUGIN_URL . '/client/blocks/index.js',
            [],
            $version,
            true
        );
        wp_set_script_translations(
            'wc-coinaccepted-blocks-integration',
            'coinaccepted'
        );
        return array( 'wc-coinaccepted-blocks-integration' );
    }

    public function get_payment_method_data(): array {
        return array(
            'title'       => $this->get_setting( 'coinaccepted_payment_title' ) ?: 'CoinAccepted',
            'description' => __('Cryptocurrency payments.', 'coinaccepted'),
            'supports'    => $this->get_supported_features(),
            'logo_url'    => WOOCOMMERCE_COINACCEPTED_PLUGIN_URL . 'resources/images/logo.svg',
        );
    }

    /**
     * Returns an array of supported features.
     *
     * @return string[]
     */
    public function get_supported_features() {
        $payment_gateways = WC()->payment_gateways->payment_gateways();
        return $payment_gateways['coinaccepted']->supports;
    }
}
