const { registerPaymentMethod } = window.wc.wcBlocksRegistry;
const { getSetting } = window.wc.wcSettings;

const getCoinAcceptedData = () => {
    const coinacceptedData = getSetting('coinaccepted_data', null);
    if (!coinacceptedData) {
        throw new Error('coinaccepted initialization data is not available');
    }
    return coinacceptedData;
};

const label = window.wp.htmlEntities.decodeEntities( getCoinAcceptedData()?.title);

const Content = () => {
    return window.wp.htmlEntities.decodeEntities( getCoinAcceptedData()?.description );
};

registerPaymentMethod({
    name: 'coinaccepted',
    label: Object( window.wp.element.createElement )( 'img', {src: getCoinAcceptedData()?.logo_url, alt: getCoinAcceptedData()?.title} ),
    ariaLabel: label,
    canMakePayment: () => true,
    content: Object( window.wp.element.createElement )(Content),
    edit: Object( window.wp.element.createElement )(Content),
    supports: {
        features: getCoinAcceptedData()?.supports ?? [],
    },
});
