<?php

declare(strict_types=1);

namespace CoinAccepted\Payment;

class PaymentResult
{
    private string $paymentId;
    private string $url;

    public function __construct(
        string $paymentId,
        string $url
    ) {
        $this->paymentId = $paymentId;
        $this->url = $url;
    }

    public function getPaymentId(): string
    {
        return $this->paymentId;
    }

    public function getUrl(): string
    {
        return $this->url;
    }
}
