<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

class CoinAcceptedModel extends ObjectModel
{
    public ?int $order_id;

    public string $transaction_id;

    public string $action_required_link;

    const TABLE = 'coinaccepted';
    const ORDER_ID = 'order_id';
    const TRANSACTION_ID = 'transaction_id';
    const ACTION_REQUIRED_LINK = 'action_required_link';


    /**
     * @var array
     */
    public static $definition = [
        'table' => self::TABLE,
        'primary' => self::ORDER_ID,
        'fields' => [
            self::ORDER_ID => ['type' => self::TYPE_INT, 'required' => true],
            self::TRANSACTION_ID => ['type' => self::TYPE_STRING, 'required' => true],
            self::ACTION_REQUIRED_LINK => ['type' => self::TYPE_STRING, 'required' => false],
        ],
    ];

    public function saveLink(int $orderId, string $transactionId, string $actionRequiredLink)
    {
        $this->order_id = $orderId;
        $this->transaction_id = $transactionId;
        $this->action_required_link = $actionRequiredLink;

        $this->save();
    }
}
