<?php

use CoinAccepted\Payment\Helper;
use CoinAccepted\Payment\Payment;

/**
 * @property bool display_column_left
 * @property bool display_column_right
 */
class CoinAcceptedPaymentModuleFrontController extends ModuleFrontController
{
	public function init()
	{
		$this->display_column_left = false;
		$this->display_column_right = false;
		parent::init();
	}

	/**
	 * @throws Exception
	 */
	public function initContent()
	{
		parent::initContent();

		$cart = $this->context->cart;

		if(!$cart->date_upd) {
			Tools::redirect('/');

			return;
		}

		$cartId = $cart->id;

		$customer = new Customer(intval($cart->id_customer));

		$coinAccepted = new CoinAccepted();
		$coinAccepted->validateOrder($cartId,
			Configuration::get('PAYMENT_COINACCEPTED_NEW_STATUS'),
			$cart->getOrderTotal(),
			$coinAccepted->displayName,
			null,
			[],
			null,
			false,
			$customer->secure_key
		);

		$currencyInfo = Currency::getCurrency($cart->id_currency);

		$orderId = Order::getOrderByCartId((int) $cartId);
		$order = new Order($orderId);

		$payment = new Payment(
			Configuration::get('COINACCEPTED_PRIVATE_KEY'),
			Configuration::get('COINACCEPTED_PUBLIC_KEY')
		);

		try {
			$response = $payment->buildOrder(
				$currencyInfo['iso_code'],
				Order::getOrderByCartId($cartId),
				round($order->total_paid, 2),
                $customer->email,
				$this->context->link->getModuleLink('coinaccepted', 'notification') ,
				Configuration::get('COINACCEPTED_GA')
					? $this->context->link->getModuleLink('coinaccepted', 'success', [
					'cart_id' => $cartId,
				])
					: $this->context->link->getModuleLink('coinaccepted', 'success'),
				$this->context->link->getModuleLink('coinaccepted', 'failure')
			);
		} catch (Exception $e) {

			$lang = $this->getLanguage();

			PrestaShopLogger::addLog(__METHOD__ . ' ' . Helper::getErrorMessage($e->getMessage(), $lang), 3);

			$this->context->smarty->assign([
				'error'   => Helper::getErrorMessage(Helper::ERROR_MESSAGE_FOR_CUSTOMER, $lang),
				'homeUrl' => _PS_BASE_URL_ . __PS_BASE_URI__,
			]);

			$this->setTemplate(CoinAccepted::buildTemplatePath('redirectfail', 'front'));

			return;
		}

        Tools::redirect($response->getUrl());
	}

	/**
	 * @return string
	 */
	private function getLanguage()
	{
		return $this->context->language->iso_code === 'pl'
			? 'pl'
			: 'en';
	}
}
