<?php

/**
 * @property bool display_column_left
 * @property bool display_column_right
 */
class CoinAcceptedSuccessModuleFrontController extends ModuleFrontController
{
	public function init()
	{
		$this->display_column_left = false;
		$this->display_column_right = false;
		parent::init();
	}

	/**
	 * @throws PrestaShopException
	 */
	public function initContent()
	{
		parent::initContent();

		$cartId = (int) Tools::getValue('cart_id');

		$cart = new Cart($cartId);
		$order = new Order(Order::getIdByCartId((int) ($cart->id)));

		$this->context->smarty->assign([
			'HOOK_ORDER_CONFIRMATION' => Hook::exec('displayOrderConfirmation', [
				'order' => $order,
			]),
		]);

		$this->setTemplate(CoinAccepted::buildTemplatePath('success', 'front'));
	}
}
