<?php

class ControllerExtensionPaymentCoinAccepted extends Controller
{

	private $error = [];

	/**
	 * View admin panel.
	 */
	public function index()
	{
		$this->language->load('extension/payment/coinaccepted');
		$this->document->setTitle($this->language->get('text_heading_title'));
		$this->load->model('setting/setting');

		$request = $this->request->post;

		if(($this->request->server['REQUEST_METHOD'] == 'POST')
			&& $this->validate()
		) {

			$settings = array_merge($this->model_setting_setting->getSetting('payment_coinaccepted'), $request);
			$this->model_setting_setting->editSetting('payment_coinaccepted', $settings);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));

			return;
		}

		include_once(DIR_SYSTEM . 'library/coinaccepted-payment-core/vendor/autoload.php');

		$base_url = $this->config->get('config_url');

		if(isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$base_url = $this->config->get('config_ssl');
		}

		$data = [
			'coinaccepted_status' => isset($this->request->post['payment_coinaccepted_status'])
				? $this->request->post['payment_coinaccepted_status']
				: $this->config->get('payment_coinaccepted_status'),

			'coinaccepted_private_key' => isset($this->request->post['payment_coinaccepted_private_key'])
				? $this->request->post['payment_coinaccepted_private_key']
				: $this->config->get('payment_coinaccepted_private_key'),

			'coinaccepted_public_key' => isset($this->request->post['payment_coinaccepted_public_key'])
				? $this->request->post['payment_coinaccepted_public_key']
				: $this->config->get('payment_coinaccepted_public_key'),

			'coinaccepted_sort_order' => isset($this->request->post['payment_coinaccepted_sort_order'])
				? $this->request->post['payment_coinaccepted_sort_order']
				: $this->config->get('payment_coinaccepted_sort_order'),

			'coinaccepted_payment_title_default' => $this->language->get('text_coinaccepted_payment_title_default'),
			'coinaccepted_payment_title'         => isset($this->request->post['payment_coinaccepted_payment_title'])
				? $this->request->post['payment_coinaccepted_sort_order']
				: $this->config->get('payment_coinaccepted_payment_title'),

			'error_validation' => $this->error,

			'notification_url' => $base_url . 'index.php?route=extension/payment/coinaccepted/notification',

			'confirm_url' => $this->url->link('extension/payment/coinaccepted', 'user_token=' . $this->session->data['user_token'], true),
			'cancel_url'  => $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'], true),

			'content_footer'      => $this->load->controller('common/footer'),
			'content_header'      => $this->load->controller('common/header'),
			'content_column_left' => $this->load->controller('common/column_left'),
			'heading_title'       => $this->language->get('text_heading_title'),

			'breadcrumbs' => [
				[
					'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
					'separator' => false,
				],

				[
					'text'      => $this->language->get('text_payment'),
					'href'      => $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'], 'SSL'),
					'separator' => ' :: ',
				],

				[
					'text'      => $this->language->get('text_heading_title'),
					'href'      => $this->url->link('extension/payment/coinaccepted', 'user_token=' . $this->session->data['user_token'], 'SSL'),
					'separator' => ' :: ',
				],
			],

		];

		$this->response->setOutput($this->load->view('extension/payment/coinaccepted', $data));
	}

	/**
	 * @return bool
	 */
	protected function validate()
	{
		if(!$this->user->hasPermission('modify', 'extension/payment/coinaccepted')) {
			$this->error['permission'] = true;

			return false;
		}

        return empty($this->error);
    }
}
