<?php

use CoinAccepted\Payment\Util;

class ModelExtensionPaymentCoinAccepted extends Model
{
	/**
	 * @param $address
	 * @param $total
	 *
	 * @return array
	 */
	public function getMethod($address, $total)
	{

		$this->load->model('setting/setting');

		include_once(DIR_SYSTEM . 'library/coinaccepted-payment-core/vendor/autoload.php');

		$this->language->load('extension/payment/coinaccepted');
		$order_currency = $this->session->data['currency'];

		if(Util::canUseForCurrency($order_currency)
			&& $this->config->get('payment_coinaccepted_public_key')
			&& $this->config->get('payment_coinaccepted_private_key')) {

			return [
				'code'       => 'coinaccepted',
				'title'      => $this->config->get('payment_coinaccepted_payment_title')
					?: $this->language->get('text_coinaccepted_payment_title_default'),
				'terms'      => '',
				'sort_order' => $this->config->get('payment_coinaccepted_sort_order'),
			];
		}

		return [];
	}
}
