<?php

use CoinAccepted\Payment\CoinAccepted;
use CoinAccepted\Payment\Helper;
use CoinAccepted\Payment\Payment;
use CoinAccepted\Payment\Util;

class ControllerExtensionPaymentCoinAccepted extends Controller
{

	/**
	 * plugin version
	 */
	const VERSION = '1.2.0';

	/**
	 * @return mixed
	 */
	public function index()
	{

		$this->language->load('extension/payment/coinaccepted');

		include_once(DIR_SYSTEM . 'library/coinaccepted-payment-core/vendor/autoload.php');

		$this->load->model('setting/setting');

		$data = [
			'url_pay' => $this->url->link('extension/payment/coinaccepted/pay', '', true),
		];

		return $this->load->view('extension/payment/coinaccepted', $data);
	}

	/**
	 * initiate form payment, make payment
	 *
	 * @throws Exception
	 */
	public function pay()
	{
		include_once(DIR_SYSTEM . 'library/coinaccepted-payment-core/vendor/autoload.php');

		$this->load->model('checkout/order');
		$this->language->load('extension/payment/coinaccepted');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$payment = new Payment(
			$this->config->get('payment_coinaccepted_private_key'),
			$this->config->get('payment_coinaccepted_public_key')
		);

		$base_url = $this->config->get('config_url');

		if(isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$base_url = $this->config->get('config_ssl');
		}

		try {

			$response = $payment->buildOrder(
				$order_info['currency_code'],
				$order_info['order_id'],
				round($order_info['total'], 2),
                $order_info['email'],
                $base_url . 'index.php?route=extension/payment/coinaccepted/notification',
				$this->url->link('checkout/success'),
				$this->url->link('checkout/success')
			);
		} catch(Exception $e) {

			$lang = $this->getLanguage();

			$this->log->write('CoinAccepted: ' . Helper::getErrorMessage($e->getMessage(), $lang));

			$this->response->setOutput($this->load->view('extension/payment/coinaccepted_redirect_fail', [
				'form' => Helper::getErrorMessage(Helper::ERROR_MESSAGE_FOR_CUSTOMER, $lang),
			]));

			return;
		}

		$this->model_checkout_order->addOrderHistory($order_info['order_id'], 01);

		$this->load->language('checkout/cart');
		$this->cart->clear();

		unset($this->session->data['vouchers']);
		unset($this->session->data['shipping_method']);
		unset($this->session->data['shipping_methods']);
		unset($this->session->data['payment_method']);
		unset($this->session->data['payment_methods']);
		unset($this->session->data['reward']);

		$this->response->setOutput($this->load->view('extension/payment/coinaccepted_redirect',
			[
				'redirect' => $response->getUrl(),
                'button' => $this->language->get('text_submit')
			]
		));
	}

	/**
	 * Support incoming notification (and validate)
	 *
	 * @throws Exception
	 */
	public function notification()
	{

		include_once(DIR_SYSTEM . 'library/coinaccepted-payment-core/vendor/autoload.php');

		if(!($payload_decoded = CoinAccepted::validateNotification())) {
			CoinAccepted::responseNotificationHeader(Util::HTTP_CODE_404);

			return;
		}

		if(!($transaction_api = CoinAccepted::checkTransaction($payload_decoded['paymentId'], $this->config->get('payment_coinaccepted_private_key'), $this->config->get('payment_coinaccepted_public_key')))) {
			CoinAccepted::responseNotificationHeader(Util::HTTP_CODE_404);

			return;
		}

		$this->load->model('checkout/order');

		if(!($order = $this->model_checkout_order->getOrder($payload_decoded['orderId']))) {
			CoinAccepted::responseNotificationHeader(Util::HTTP_CODE_404);

			return;
		}

		if(!($order['order_status_id'] === '1' || $order['order_status_id'] === '10')) {
			CoinAccepted::responseNotificationHeader(Util::HTTP_CODE_404);

			return;
		}

        if($transaction_api['data']['amountInDestinationCurrency'] !== (float) $order['total']) {
            CoinAccepted::responseNotificationHeader(Util::HTTP_CODE_404);

            return;
        }

        switch($transaction_api['data']['status']) {
            case Util::TRANSACTION_STATUS_COMPLETED:
                $this->model_checkout_order->addOrderHistory($order['order_id'], 02);
                break;
            case Util::TRANSACTION_STATUS_ACTION_REQUIRED:
                $this->language->load('extension/payment/coinaccepted');
                $message = sprintf($this->language->get('text_action_required'),  $payload_decoded['travelRuleFormUrl'] ?? '');
                $this->model_checkout_order->addOrderHistory($order['order_id'], $order['order_status_id'], $message);
                break;
            default:
                CoinAccepted::responseNotificationHeader(Util::HTTP_CODE_404);

                return;
        }

		CoinAccepted::responseNotificationHeader(Util::HTTP_CODE_200);
	}

	/**
	 * @return string
	 */
	private function getLanguage()
	{
		$locale_code = strtolower($this->language->get('code'));

		if($locale_code === 'pl' || $locale_code === 'pl-pl') {
			return 'pl';
		}

		return 'en';
	}
}
