<?php

declare(strict_types=1);

namespace CoinAccepted\Payment\Model\Ui;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Asset\Repository;

class Logo
{
    private const LOGO = 'CoinAccepted_Payment::images/logo.svg';

    private RequestInterface $request;

    private Repository $assetRepository;

    public function __construct(
        RequestInterface $request,
        Repository $assetRepository
    ) {
        $this->request = $request;
        $this->assetRepository = $assetRepository;
    }

    public function getUrl(): ?string
    {
        try {
            $asset = $this->assetRepository->createAsset(self::LOGO, ['_secure' => $this->request->isSecure()]);
        } catch (LocalizedException $e) {
            return null;
        }

        return $asset->getUrl();
    }
}
