<?php

namespace CoinAccepted\Payment\Model;

use Magento\Framework\Api\AttributeValueFactory;
use Magento\Framework\Api\ExtensionAttributesFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Framework\UrlInterface;
use Magento\Payment\Helper\Data;
use Magento\Payment\Model\Method\Logger;
use CoinAccepted\Payment\Util;
use CoinAccepted\Payment\Model\Payment\AbstractPaymentGateway;

class Payment extends AbstractPaymentGateway
{
	private const CODE = 'coinaccepted_payment';

    public const TRAVEL_RULE_INFO = '<b>Coin Accepted</b>: Payer action is required. Need to include information needed for <a target="_blank" href="%1">Travel Rule</a> message: <a target="_blank" href="%2">%2</a>.';
    public const TRAVEL_RULE_LINK = 'https://coinaccepted.com/en/helpdesk/bitcoin-cryptocurrencies/travel-rule';

    public const PAYMENT_URL_ADDITIONAL_INFORMATION = 'payment_url';

	private UrlInterface $urlBuilder;

	/**
	 * @var string
	 */
	protected $code = self::CODE;

	public function __construct(
		Context $context,
		Registry $registry,
		ExtensionAttributesFactory $extensionFactory,
		AttributeValueFactory $customAttributeFactory,
		Data $paymentData,
		ScopeConfigInterface $scopeConfig,
		Logger $logger,
		UrlInterface $urlBuilder,
		AbstractResource $resource = null,
		AbstractDb $resourceCollection = null,
		array $data = []
	) {
		parent::__construct(
			$context,
			$registry,
			$extensionFactory,
			$customAttributeFactory,
			$paymentData,
			$scopeConfig,
			$logger,
			$resource,
			$resourceCollection,
            $urlBuilder,
			$data
		);

		$this->urlBuilder = $urlBuilder;
	}

	public function getCheckoutRedirectUrl(): string
	{
		return $this->urlBuilder->getUrl('ca_cryptocurrencies/payment/redirect');
	}

	/**
	 * @param string $currencyCode
	 */
	public function canUseForCurrency($currencyCode): bool
	{
		return Util::canUseForCurrency(strtolower($currencyCode))
			&& $this->getConfigData('private_key')
			&& $this->getConfigData('public_key');
	}
}
