<?php

namespace CoinAccepted\Payment\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Payment\Helper\Data;
use CoinAccepted\Payment\Model\Ui\Logo;
use Magento\Payment\Model\MethodInterface;

class ConfigProvider implements ConfigProviderInterface
{
	const PP_CODE = 'coinaccepted_payment';

    /**
     * @var Payment
     */
	private MethodInterface $paymentMethod;

    private Logo $logo;

    /**
     * @throws LocalizedException
     */
	public function __construct(
        Data $paymentHelper,
        Logo $logo
    ) {
		$this->paymentMethod = $paymentHelper->getMethodInstance(self::PP_CODE);
        $this->logo = $logo;
    }

	public function getConfig(): array
	{
		$config = [];

		if($this->paymentMethod->isAvailable()) {
			$config = [
				'payment' => [
					self::PP_CODE => [
						'redirectUrl' => $this->paymentMethod->getCheckoutRedirectUrl(),
                        'logoUrl' => $this->logo->getUrl(),
					],
				],
			];
		}

		return $config;
	}
}
