define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/action/redirect-on-success',
    ],
    function ($, Component, redirectOnSuccessAction) {
        'use strict';

        return Component.extend({
            defaults: {
                template: 'CoinAccepted_Payment/payment/coinaccepted-payment.html'
            },
            getData: function () {
                return {
                    "method": this.item.method,
                };
            },
            afterPlaceOrder: function () {
                redirectOnSuccessAction.redirectUrl = window.checkoutConfig.payment.coinaccepted_payment.redirectUrl;
            },
            getLogo: function () {
                return window.checkoutConfig.payment.coinaccepted_payment.logoUrl;
            },
        });
    }
);
