<?php

namespace CoinAccepted\Payment\Controller\Payment;

use Magento\Checkout\Model\Session;
use Magento\Checkout\Model\Session\SuccessValidator;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\UrlInterface;
use Magento\Sales\Model\Order\Payment;
use CoinAccepted\Payment\Model\Payment as CoinAcceptedPayment;

class Redirect implements HttpGetActionInterface
{
    private RedirectFactory $redirectFactory;
    private UrlInterface $urlBuilder;
    private SuccessValidator $checkoutSuccessValidator;
    private Session $checkoutSession;

    public function __construct(
        RedirectFactory $redirectFactory,
        UrlInterface $urlBuilder,
        SuccessValidator $checkoutSuccessValidator,
        Session $checkoutSession,
    ) {
        $this->redirectFactory = $redirectFactory;
        $this->urlBuilder = $urlBuilder;
        $this->checkoutSuccessValidator = $checkoutSuccessValidator;
        $this->checkoutSession = $checkoutSession;
    }

	public function execute(): ResultInterface
	{
        $result = $this->redirectFactory->create();
        if (!$this->checkoutSuccessValidator->isValid()) {
            return $result->setUrl($this->urlBuilder->getUrl('checkout/onepage/failure/'));
        }

        $order = $this->checkoutSession->getLastRealOrder();

        /** @var Payment $payment */
        $payment = $order->getPayment();

        return $result->setUrl($payment->getAdditionalInformation(CoinAcceptedPayment::PAYMENT_URL_ADDITIONAL_INFORMATION));
	}
}
